"use strict";
var constants = require("@pixi/constants");
function mapInternalFormatToSamplerType(gl) {
  let table;
  return "WebGL2RenderingContext" in globalThis && gl instanceof globalThis.WebGL2RenderingContext ? table = {
    [gl.RGB]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.ALPHA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.LUMINANCE]: constants.SAMPLER_TYPES.FLOAT,
    [gl.LUMINANCE_ALPHA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R8_SNORM]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RG8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RG8_SNORM]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB8_SNORM]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB565]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA4]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB5_A1]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA8_SNORM]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB10_A2]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB10_A2UI]: constants.SAMPLER_TYPES.FLOAT,
    [gl.SRGB8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.SRGB8_ALPHA8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R16F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RG16F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB16F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA16F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R32F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RG32F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB32F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA32F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R11F_G11F_B10F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGB9_E5]: constants.SAMPLER_TYPES.FLOAT,
    [gl.R8I]: constants.SAMPLER_TYPES.INT,
    [gl.R8UI]: constants.SAMPLER_TYPES.UINT,
    [gl.R16I]: constants.SAMPLER_TYPES.INT,
    [gl.R16UI]: constants.SAMPLER_TYPES.UINT,
    [gl.R32I]: constants.SAMPLER_TYPES.INT,
    [gl.R32UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RG8I]: constants.SAMPLER_TYPES.INT,
    [gl.RG8UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RG16I]: constants.SAMPLER_TYPES.INT,
    [gl.RG16UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RG32I]: constants.SAMPLER_TYPES.INT,
    [gl.RG32UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGB8I]: constants.SAMPLER_TYPES.INT,
    [gl.RGB8UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGB16I]: constants.SAMPLER_TYPES.INT,
    [gl.RGB16UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGB32I]: constants.SAMPLER_TYPES.INT,
    [gl.RGB32UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGBA8I]: constants.SAMPLER_TYPES.INT,
    [gl.RGBA8UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGBA16I]: constants.SAMPLER_TYPES.INT,
    [gl.RGBA16UI]: constants.SAMPLER_TYPES.UINT,
    [gl.RGBA32I]: constants.SAMPLER_TYPES.INT,
    [gl.RGBA32UI]: constants.SAMPLER_TYPES.UINT,
    [gl.DEPTH_COMPONENT16]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH_COMPONENT24]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH_COMPONENT32F]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH_STENCIL]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH24_STENCIL8]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH32F_STENCIL8]: constants.SAMPLER_TYPES.FLOAT
  } : table = {
    [gl.RGB]: constants.SAMPLER_TYPES.FLOAT,
    [gl.RGBA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.ALPHA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.LUMINANCE]: constants.SAMPLER_TYPES.FLOAT,
    [gl.LUMINANCE_ALPHA]: constants.SAMPLER_TYPES.FLOAT,
    [gl.DEPTH_STENCIL]: constants.SAMPLER_TYPES.FLOAT
  }, table;
}
exports.mapInternalFormatToSamplerType = mapInternalFormatToSamplerType;
//# sourceMappingURL=mapInternalFormatToSamplerType.js.map
