import { LINE_CAP, LINE_JOIN } from '@pixi/graphics';
import { JOINT_TYPE } from './const.mjs';

class SmoothGraphicsData {
  constructor(shape, fillStyle = null, lineStyle = null, matrix = null) {
    this.shape = shape;
    this.lineStyle = lineStyle;
    this.fillStyle = fillStyle;
    this.matrix = matrix;
    this.type = shape.type;
    this.points = [];
    this.holes = [];
    this.triangles = [];
    this.closeStroke = false;
    this.clearBuild();
  }
  clearPath() {
    this.points.length = 0;
    this.closeStroke = true;
  }
  clearBuild() {
    this.triangles.length = 0;
    this.fillStart = 0;
    this.fillLen = 0;
    this.strokeStart = 0;
    this.strokeLen = 0;
    this.fillAA = false;
  }
  clone() {
    return new SmoothGraphicsData(
      this.shape,
      this.fillStyle,
      this.lineStyle,
      this.matrix
    );
  }
  capType() {
    let cap;
    switch (this.lineStyle.cap) {
      case LINE_CAP.SQUARE:
        cap = JOINT_TYPE.CAP_SQUARE;
        break;
      case LINE_CAP.ROUND:
        cap = JOINT_TYPE.CAP_ROUND;
        break;
      default:
        cap = JOINT_TYPE.CAP_BUTT;
        break;
    }
    return cap;
  }
  goodJointType() {
    let joint;
    switch (this.lineStyle.join) {
      case LINE_JOIN.BEVEL:
        joint = JOINT_TYPE.JOINT_BEVEL;
        break;
      case LINE_JOIN.ROUND:
        joint = JOINT_TYPE.JOINT_ROUND;
        break;
      default:
        joint = JOINT_TYPE.JOINT_MITER + 3;
        break;
    }
    return joint;
  }
  jointType() {
    let joint;
    switch (this.lineStyle.join) {
      case LINE_JOIN.BEVEL:
        joint = JOINT_TYPE.JOINT_BEVEL;
        break;
      case LINE_JOIN.ROUND:
        joint = JOINT_TYPE.JOINT_ROUND;
        break;
      default:
        joint = JOINT_TYPE.JOINT_MITER;
        break;
    }
    return joint;
  }
  destroy() {
    this.shape = null;
    this.holes.length = 0;
    this.holes = null;
    this.points.length = 0;
    this.points = null;
    this.lineStyle = null;
    this.fillStyle = null;
    this.triangles = null;
  }
}

export { SmoothGraphicsData };
//# sourceMappingURL=SmoothGraphicsData.mjs.map
