import { JOINT_TYPE } from '../core/const.mjs';
import { PolyBuilder } from './PolyBuilder.mjs';

class RectangleBuilder {
  constructor() {
    this._polyBuilder = new PolyBuilder();
  }
  path(graphicsData, _target) {
    const rectData = graphicsData.shape;
    const x = rectData.x;
    const y = rectData.y;
    const width = rectData.width;
    const height = rectData.height;
    const points = graphicsData.points;
    points.length = 0;
    points.push(
      x,
      y,
      x + width,
      y,
      x + width,
      y + height,
      x,
      y + height
    );
  }
  line(graphicsData, target) {
    const { verts, joints } = target;
    const { points } = graphicsData;
    const joint = graphicsData.goodJointType();
    const len = points.length;
    verts.push(points[len - 2], points[len - 1]);
    joints.push(JOINT_TYPE.NONE);
    for (let i = 0; i < len; i += 2) {
      verts.push(points[i], points[i + 1]);
      joints.push(joint);
    }
    verts.push(points[0], points[1]);
    joints.push(JOINT_TYPE.NONE);
    verts.push(points[2], points[3]);
    joints.push(JOINT_TYPE.NONE);
  }
  fill(graphicsData, target) {
    const { verts, joints } = target;
    const { points, triangles } = graphicsData;
    triangles.length = 0;
    if (!graphicsData.fillAA) {
      verts.push(
        points[0],
        points[1],
        points[2],
        points[3],
        points[4],
        points[5],
        points[6],
        points[7]
      );
      joints.push(JOINT_TYPE.FILL, JOINT_TYPE.FILL, JOINT_TYPE.FILL, JOINT_TYPE.FILL);
      triangles.push(0, 1, 2, 0, 2, 3);
      return;
    }
    this._polyBuilder.fill(graphicsData, target);
  }
}

export { RectangleBuilder };
//# sourceMappingURL=RectangleBuilder.mjs.map
